local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
    Asset("ANIM", "anim/aegis.zip"), 
}

local SpawnLootPrefab = require("spawnlootprefab")

local excluded = {
    researchlab4 = true,
    pighouse = true,
    rabbithouse = true,
    tent = true,
    siestahut = true,
    pighead = true,
    mermhead = true,
    --CAPY_DLC
    piratihatitator = true,
    wildborehouse = true,
    primeapebarrel = true,
    rowboat = true,
    raft = true,
    lograft = true,
    surfboard = true,
    cargoboat = true,
    armouredboat = true,
}

local function finishedwork(inst, data)
    if data.target and data.action == ACTIONS.HAMMER then
        local recipe = GetRecipe(data.target.prefab)
        if recipe and not excluded[recipe.name] then
            for k, v in pairs(recipe.ingredients) do
				local amt = RoundDown(v.amount * (data.target:HasTag("burnt") and (1 - TUNING.BURNT_HAMMER_LOOT_PERCENT) or (1 - TUNING.HAMMER_LOOT_PERCENT)))
                for i = 1, amt do
                    local self = {inst = data.target,}
                    SpawnLootPrefab(self, v.type)
                end
            end
        end
    end
end

local fn = function(inst)
    inst.MiniMapEntity:SetIcon("aegis.tex")
    
    inst.soundsname = "willow"
    
    inst:ListenForEvent("finishedwork", finishedwork)
end

return MakePlayerCharacter("aegis", {}, assets, fn, {})